Ext.data.JsonP.sol_common_JsonUtils({"tagname":"class","name":"sol.common.JsonUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.JsonUtils.js","href":"lib_sol.common.JsonUtils.html#sol-common-JsonUtils"}],"author":[{"tagname":"author","name":"Michael Weiler, ELO Digital Office GmbH","email":null}],"version":["1.0"],"eloall":true,"requires":["sol"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"deserialize","tagname":"method","owner":"sol.common.JsonUtils","id":"method-deserialize","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"serialize","tagname":"method","owner":"sol.common.JsonUtils","id":"method-serialize","meta":{}},{"name":"stringifyAll","tagname":"method","owner":"sol.common.JsonUtils","id":"method-stringifyAll","meta":{}},{"name":"stringifyQuick","tagname":"method","owner":"sol.common.JsonUtils","id":"method-stringifyQuick","meta":{"private":true}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.JsonUtils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.JsonUtils</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol' rel='sol' class='docClass'>sol</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.JsonUtils.html#sol-common-JsonUtils' target='_blank'>lib_sol.common.JsonUtils.js</a></div></pre><div class='doc-contents'><p>Helper functions for JSON processing</p>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-deserialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.JsonUtils'>sol.common.JsonUtils</span><br/><a href='source/lib_sol.common.JsonUtils.html#sol-common-JsonUtils-method-deserialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.JsonUtils-method-deserialize' class='name expandable'>deserialize</a>( <span class='pre'>json, className</span> ) : java.lang.Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Deserializes a Java object ...</div><div class='long'><p>Deserializes a Java object</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>json</span> : String<div class='sub-desc'><p>JSON</p>\n</div></li><li><span class='pre'>className</span> : String<div class='sub-desc'><p>Class name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.lang.Object</span><div class='sub-desc'><p>javaObject Java object</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-serialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.JsonUtils'>sol.common.JsonUtils</span><br/><a href='source/lib_sol.common.JsonUtils.html#sol-common-JsonUtils-method-serialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.JsonUtils-method-serialize' class='name expandable'>serialize</a>( <span class='pre'>javaObject</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Serializes a Java object ...</div><div class='long'><p>Serializes a Java object</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>javaObject</span> : java.lang.Object<div class='sub-desc'><p>Java object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-stringifyAll' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.JsonUtils'>sol.common.JsonUtils</span><br/><a href='source/lib_sol.common.JsonUtils.html#sol-common-JsonUtils-method-stringifyAll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.JsonUtils-method-stringifyAll' class='name expandable'>stringifyAll</a>( <span class='pre'>obj, objFormat</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Stringify JavaScript objects and handles Java objects ...</div><div class='long'><p>Stringify JavaScript objects and handles Java objects</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>obj</span> : Object<div class='sub-desc'><p>Object to stringify</p>\n</div></li><li><span class='pre'>objFormat</span> : Object<div class='sub-desc'><p>Object formatting stringify e.g. objFormat = {tabStop: 2}</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>string value of object</p>\n</div></li></ul></div></div></div><div id='method-stringifyQuick' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.JsonUtils'>sol.common.JsonUtils</span><br/><a href='source/lib_sol.common.JsonUtils.html#sol-common-JsonUtils-method-stringifyQuick' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.JsonUtils-method-stringifyQuick' class='name expandable'>stringifyQuick</a>( <span class='pre'>obj</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>obj</span> : Object<div class='sub-desc'></div></li></ul></div></div></div></div></div></div></div>","meta":{"eloall":true,"singleton":true}});